﻿$(document).on("pageinit", function () {
    $(".questionContainer[data-questiontype='imageareaselector'] .imageMap .area").on("click", function () {
        var checkBox = $(":checkbox", $(this));
        var imageMap = $(this).closest(".imageMap");
        var maxAnswers = imageMap.attr("data-maxanswers");
        var selectedChoices = imageMap.data("selectedChoices");

        if (!selectedChoices) {
            selectedChoices = new Array();
        }

        if (checkBox.is(":checked")) {
            selectedChoices = $.grep(selectedChoices, function (value) { return value != checkBox.attr("id"); });
            checkBox.prop("checked", false);
            $(this).removeClass("selectedImageArea");
        }
        else {
            if (checkBox.attr("data-exclusive") == "true") {
                $(":checkbox", imageMap).prop("checked", false);
                $(".area", imageMap).removeClass("selectedImageArea");
                selectedChoices = new Array();
            }
            else if (maxAnswers != null && maxAnswers > 0 && selectedChoices != null && selectedChoices.length >= maxAnswers) {
                var checkBoxToUncheck = $("#" + selectedChoices[0]);
                var area = checkBoxToUncheck.closest(".area");
                selectedChoices.splice(0, 1);
                checkBoxToUncheck.prop("checked", false);
                area.removeClass("selectedImageArea");
            }

            var exclusiveChoice = $(":checkbox[data-exclusive='true']:checked", imageMap);
            exclusiveChoice.prop("checked", false);
            exclusiveChoice.closest(".area").removeClass("selectedImageArea");
            selectedChoices = $.grep(selectedChoices, function (value) { return value != exclusiveChoice.attr("id"); });

            checkBox.prop("checked", true);
            $(this).addClass("selectedImageArea");
            selectedChoices.push(checkBox.attr("id"));
        }

        checkBox.trigger("change");

        $(".area", imageMap).each(function () {
            UpdateImageAreaSelectorAreaColor($(this));
        });

        imageMap.data("selectedChoices", selectedChoices);
    });
});